﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace SortingAndSearching
{
    class CArray
    {
        private int[] arr;
        private int upper;
        private int numElements;
        public CArray(int size)
        {
            arr = new int[size];
            upper = size - 1;
            numElements = 0;
        }
        //*****************
        public void Insert(int item)
        {
            arr[numElements] = item;
            numElements++;
        }
        //*****************
        public void DisplayElements()
        {
            for (int i = 0; i <= upper; i++)
                Console.Write(arr[i] + " ");
            Console.WriteLine();
        }
        //*****************
        public void Clear()
        {
            for (int i = 0; i <= upper; i++)
                arr[i] = 0;
            numElements = 0;
        }
        //*****************
        public void BubbleSort()
        {
            int temp;
            bool switched = true;
            for (int i = numElements - 1; (i > 0 && switched); i--)
            {
                switched = false;
                for (int j = 0; j < i; j++)
                    if (arr[j] > arr[j + 1])
                    {
                        switched = true;
                        temp = arr[j];
                        arr[j] = arr[j + 1];
                        arr[j + 1] = temp;
                    }
            }
        }//end of BubbleSort
        //********************
        public void QuickSort(int first, int last)
        {
            int pos = 0;  //final position of pivot
            if (first < last)
            {
                //split into two subList
                pos = Split(first, last, pos);
                //sort left sublist
                QuickSort(first, pos - 1);
                //sort right sublist
                QuickSort(pos + 1, last);
            }//end of if
            //else list has 0 or 1 element
            //and require no sorting
        }//end of QuickSort
        //*********************
        public int Split(int first, int last, int pos)
        {
            int temp, left = first, right = last, pivot = arr[first];
            while (left < right)
            {
                //search from right for element <= pivot
                while (arr[right] > pivot)
                    right--;
                //search from right element <= pivot
                while (left < right && arr[left] <= pivot)
                    left++;
                //interchange element if searches have not met
                if (left < right)
                {
                    temp = arr[left];
                    arr[left] = arr[right];
                    arr[right] = temp;
                }
            }//end of while
            pos = right;
            arr[first] = arr[pos];
            arr[pos] = pivot;
            return pos;
        }//end of Split
        public void SelectionSort()
        {
            int minPos, temp;
            for (int i = 0; i < numElements; i++)
            {
                minPos = i;
                for (int j = i + 1; j < numElements; j++)
                    if (arr[j] < arr[minPos])
                        minPos = j;
                temp = arr[minPos];
                arr[minPos] = arr[i];
                arr[i] = temp;
            }//end of for
        }//end of SelectionSort
        //******************
        public void InsertionSort()
        {
            int temp, j;
            for (int i = 1; i < numElements; i++)
            {
                temp = arr[i];
                for (j = i; j > 0 && arr[j - 1] > temp; j--)
                    arr[j] = arr[j - 1];
                arr[j] = temp;
            }//end of for
        }//end of InsertionSort
        //********************
        public void ShellSort(int[] increment)
        {
            int span, k, y;
            for (int i = 0; i < increment.Length; i++)
            {
                span = increment[i];
                for (int j = span; j < numElements; j++)
                {
                    //insert arr[j] into its proper position
                    //with its sub array
                    y = arr[j];
                    for (k = j - span; k >= 0 && y < arr[k]; k -= span)
                        arr[k + span] = arr[k];
                    arr[k + span] = y;
                }//end of for j
            }//enf of for i
        }//end of Shell
        //*************************
        public void MergeArray(int[] arr1, int[] arr2)
        {
            int i = 0, j = 0, k = 0;
            while (i < arr1.Length && j < arr2.Length)
            {
                if (arr1[i] < arr2[j])
                    arr[k++] = arr1[i++];
                else
                    arr[k++] = arr2[j++];
            }//end of while
            while (i < arr1.Length)
                arr[k++] = arr1[i++];
            while (j < arr2.Length)
                arr[k++] = arr2[j++];
        }//end of MergeArray
        //**********************
    }
}
