﻿


using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using rayaneh.commerce;


public partial class ShoppingControlCart : System.Web.UI.UserControl
{
    private void BindGrid()
    {
        CartGrid.DataSource = Profile.Cart.items;
        DataBind();
        Label1.Text = String.Format("Total:{0,19:C}", Profile.Cart.Total);
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (Profile.Cart == null)
            Profile.Cart = new rayaneh.commerce.shoppingCart();
        if (!Page.IsPostBack)
            BindGrid();
        if (Profile.Cart.items.Count == 0)
            Label1.Visible = false;

    }
    protected void CartGrid_RowEditing(object sender, GridViewEditEventArgs e)
    {
        CartGrid.EditIndex = e.NewEditIndex;
        BindGrid();

    }
    protected void CartGrid_RowUpdated(object sender, GridViewUpdatedEventArgs e)
    {

    }
    protected void CartGrid_RowCancelingEdit(object sender, GridViewCancelEditEventArgs e)
    {
        CartGrid.EditIndex = -1;
        BindGrid();

    }
    protected void CartGrid_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        Profile.Cart.items.RemoveAt(e.RowIndex);
        BindGrid();

    }
    protected void CartGrid_RowUpdating(object sender, GridViewUpdateEventArgs e)
    {
        TextBox quantityTextBox =
           (TextBox)CartGrid.Rows[e.RowIndex].Cells[2].Controls[0];
        int quantity = System.Convert.ToInt32(quantityTextBox.Text);
        if (quantity == 0)
            Profile.Cart.items.RemoveAt(e.RowIndex);
        else
            Profile.Cart.items[e.RowIndex].quantity = quantity;
        CartGrid.EditIndex = -1;
        BindGrid();

    }
}
