﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;
using System.Xml;
using System.Collections;

public partial class _Default : System.Web.UI.Page 
{
    protected void Page_Load(object sender, EventArgs e)
    {

    }
    protected void cmdCreate_Click(object sender, EventArgs e)
    {
        lblStatus.Text = "";
        // Start with a blank in memory document.
        XmlDocument doc = new XmlDocument();
        // Create some variables that will be useful for manipulating XML data.
        XmlElement RootElement, ProductElement, PriceElement;
        XmlAttribute ProductAttribute;
        XmlComment Comment;
        XmlElement StatusElement;
        // Create the declaration.
        XmlDeclaration Declaration;
        Declaration = doc.CreateXmlDeclaration("1.0", null, "yes");
        // Insert the declaration as the first node.
        doc.InsertBefore(Declaration, doc.DocumentElement);
        // Add a comment.
        Comment = doc.CreateComment("Created with the XmlDocument class.");
        doc.InsertAfter(Comment, Declaration);

        // Add the root node.
        RootElement = doc.CreateElement("BookList1");
        doc.InsertAfter(RootElement, Comment);

        // Add the first product.
        ProductElement = doc.CreateElement("Product");
        RootElement.AppendChild(ProductElement);

        // Set and add the product attributes.
        ProductAttribute = doc.CreateAttribute("ID");
        ProductAttribute.Value = "1";
        ProductElement.SetAttributeNode(ProductAttribute);

        ProductAttribute = doc.CreateAttribute("Name");
        ProductAttribute.Value = "Software Engineering";
        ProductElement.SetAttributeNode(ProductAttribute);

        // Add the price node.
        PriceElement = doc.CreateElement("Price");
        PriceElement.InnerText = "3500";
        ProductElement.AppendChild(PriceElement);

        StatusElement = doc.CreateElement("Status");
        StatusElement.InnerText = "1";
        ProductElement.AppendChild(StatusElement);

        // Add the second product.
        ProductElement = doc.CreateElement("Product");
        RootElement.AppendChild(ProductElement);

        // Set and add the product attributes.
        ProductAttribute = doc.CreateAttribute("ID");
        ProductAttribute.Value = "2";
        ProductElement.SetAttributeNode(ProductAttribute);
        ProductAttribute = doc.CreateAttribute("Name");
        ProductAttribute.Value = "Data Structures";
        ProductElement.SetAttributeNode(ProductAttribute);

        // Add the price node.
        PriceElement = doc.CreateElement("Price");
        PriceElement.InnerText = "3000";
        ProductElement.AppendChild(PriceElement);

        StatusElement = doc.CreateElement("Status");
        StatusElement.InnerText = "3";
        ProductElement.AppendChild(StatusElement);

        // Add the third product.
        ProductElement = doc.CreateElement("Product");
        RootElement.AppendChild(ProductElement);

        // Set and add the product attributes.
        ProductAttribute = doc.CreateAttribute("ID");
        ProductAttribute.Value = "3";
        ProductElement.SetAttributeNode(ProductAttribute);
        ProductAttribute = doc.CreateAttribute("Name");
        ProductAttribute.Value = "Programming with C";
        ProductElement.SetAttributeNode(ProductAttribute);

        // Add the price node.
        PriceElement = doc.CreateElement("Price");
        PriceElement.InnerText = "4000";
        ProductElement.AppendChild(PriceElement);

        StatusElement = doc.CreateElement("Status");
        StatusElement.InnerText = "2";
        ProductElement.AppendChild(StatusElement);

        // Save the document.
        doc.Save("BookList1");
        lblStatus.Text = "File BookList1 written successfully.";

    }
    protected void cmdDisplay_Click(object sender, EventArgs e)
    {
        // Create the document.
        XmlDataDocument doc = new XmlDataDocument();
        doc.Load("BookList1");
        // Loop through all the nodes, and create the ArrayList..
        ArrayList Products = new ArrayList();
        foreach (XmlElement Element in doc.DocumentElement.ChildNodes)
        {
            Product NewProduct = new Product();
            NewProduct.ID = System.Convert.ToInt32(Element.GetAttribute("ID"));
            NewProduct.Name = Element.GetAttribute("Name");
            NewProduct.Price = System.Convert.ToDecimal(Element.ChildNodes[0].InnerText);
            NewProduct.Status = System.Convert.ToInt32(Element.ChildNodes[1].InnerText);
            Products.Add(NewProduct);
        }
        // Display the results.
        dgResults.DataSource = Products;
        dgResults.DataBind();

    }
    protected void cmdSearch_Click(object sender, EventArgs e)
    {
        XmlDataDocument doc = new XmlDataDocument();
        doc.Load("BookList1");
        XmlNodeList Results;

        // Perform the search.
        Results = doc.GetElementsByTagName("Price");
        // Display the results.
        lblStatus.Text = "<b>Found " + Results.Count.ToString() + " Matches ";
        lblStatus.Text += " for the Price tag: </b><br><br>";
        foreach (XmlNode Result in Results)
            lblStatus.Text += Result.FirstChild.Value + "<br>";

    }
}
