﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;
using System.Xml;
using System.Xml.Schema;
using System.Collections;

public partial class _Default : System.Web.UI.Page 
{
    protected void Page_Load(object sender, EventArgs e)
    {

    }
    protected void cmdCreate_Click(object sender, EventArgs e)
    {
        lblStatus.Text = "";
        FileStream fs = new FileStream("BookList.xml", FileMode.Create);
        XmlTextWriter w = new XmlTextWriter(fs, null);
        w.WriteStartDocument();
        w.WriteStartElement("BookList");
        w.WriteComment("This file generated by the XmlTextWriter class.");

        // Write the first product.
        w.WriteStartElement("Product");
        w.WriteAttributeString("ID", "", "1");

        w.WriteAttributeString("Name", "", "Software Engineering");

        w.WriteStartElement("Price");
        w.WriteString("3500");
        w.WriteEndElement();

        w.WriteStartElement("Status");
        w.WriteString("2");
        w.WriteEndElement();

        // Write the second product.
        w.WriteStartElement("Product");
        w.WriteAttributeString("ID", "", "2");
        w.WriteAttributeString("Name", "", "Data Structures");

        w.WriteStartElement("Price");
        w.WriteString("3000");
        w.WriteEndElement();

        w.WriteStartElement("Status");
        w.WriteString("3");
        w.WriteEndElement();

        // Write the third product.
        w.WriteStartElement("Product");
        w.WriteAttributeString("ID", "", "3");
        w.WriteAttributeString("Name", "", "Programming With C");

        w.WriteStartElement("Price");
        w.WriteString("4000");
        w.WriteEndElement();

        w.WriteStartElement("Status");
        w.WriteString("1");
        w.WriteEndElement();

        // Close the root element.
        w.WriteEndElement();
        w.WriteEndDocument();
        w.Close();
        lblStatus.Text = "File BookList.xml written successfully.";

    }
    protected void cmdDisplay_Click(object sender, EventArgs e)
    {
        lblStatus.Text = "";
        FileStream fs;
        XmlTextReader r;
        // Store retrived products in an Arraycollection.
        ArrayList Products = new ArrayList();
        // Open a stream to the file.
        fs = new FileStream("BookList.xml", FileMode.Open);
        r = new XmlTextReader(fs);
        // Loop through the products..
        while (r.Read())
        {
            if (r.NodeType == XmlNodeType.Element && r.Name == "Product")
            {
                Product NewProduct = new Product();
                NewProduct.ID = System.Convert.ToInt32(r.GetAttribute(0));
                NewProduct.Name = r.GetAttribute(1);
                // Get the rest of the subtags for this product.
                do
                {
                    r.Read();
                    if (r.Name == "Price")
                    {
                        do
                        {
                            r.Read();
                            if (r.NodeType == XmlNodeType.Text)
                                NewProduct.Price = System.Convert.ToInt32(r.Value);

                        } while (r.NodeType != XmlNodeType.EndElement);
                    }

                    r.Read();
                    if (r.Name == "Status")
                    {
                        do
                        {
                            r.Read();
                            if (r.NodeType == XmlNodeType.Text)
                                NewProduct.Status = System.Convert.ToInt32(r.Value);

                        } while (r.NodeType != XmlNodeType.EndElement);
                    }
                    // We could check for other Product nodes
                    // (like Available, Status, etc.) here.
                } while (r.NodeType != XmlNodeType.EndElement);
                // Add the product
                Products.Add(NewProduct);
            }//if
        }// while
        r.Close();
        // Display the retrieved document.
        dgResults.DataSource = Products;
        dgResults.DataBind();


    }
    protected void cmdNode_Click(object sender, EventArgs e)
    {
        lblStatus.Text = "";
        FileStream fs = new FileStream("BookList.xml", FileMode.Open);
        XmlTextReader r = new XmlTextReader(fs);
        // Parse the file and read each node.
        while (r.Read())
        {
            lblStatus.Text += "<b>Type:</b> " + System.Convert.ToString(r.NodeType) + "<br>";
            if (r.Name != "")
                lblStatus.Text += "<b>Name:</b> " + r.Name + "<br>";

            if (r.Value != "")
                lblStatus.Text += "<b>System.Convert.ToInt32ue:</b> " + r.Value + "<br>";

            if (r.AttributeCount > 0)
            {
                lblStatus.Text += "<b>Attributes:</b> ";
                int i;
                for (i = 0; i <= r.AttributeCount - 1; i++)
                    lblStatus.Text += "  " + r.GetAttribute(i) + " &nbsp;&nbsp;&nbsp";
                lblStatus.Text += "<br>";
            }
            lblStatus.Text += "<br>";
        }
        r.Close();

    }
}
