Imports System.IO
Imports System.Xml
Public Class WebForm1
    Inherits System.Web.UI.Page
    Protected WithEvents cmdDisplay As System.Web.UI.WebControls.Button
    Protected WithEvents dgResults As System.Web.UI.WebControls.DataGrid
    Protected WithEvents cmdCreate As System.Web.UI.WebControls.Button
    Protected WithEvents lblStatus As System.Web.UI.WebControls.Label
    Protected WithEvents cmdSearch As System.Web.UI.WebControls.Button

#Region " Web Form Designer Generated Code "

    'This call is required by the Web Form Designer.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()

    End Sub

    Private Sub Page_Init(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Init
        'CODEGEN: This method call is required by the Web Form Designer
        'Do not modify it using the code editor.
        InitializeComponent()
    End Sub

#End Region

    Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        'Put user code to initialize the page here
    End Sub

    Private Sub cmdCreate_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdCreate.Click
        lblStatus.Text = ""

        ' Start with a blank in memory document.
        Dim doc As New XmlDocument()

        ' Create some variables that will be useful for manipulating XML data.
        Dim RootElement, ProductElement, PriceElement As XmlElement
        Dim ProductAttribute As XmlAttribute
        Dim Comment As XmlComment
        Dim StatusElement As XmlElement
        ' Create the declaration.
        Dim Declaration As XmlDeclaration
        Declaration = doc.CreateXmlDeclaration("1.0", Nothing, "yes")
        ' Insert the declaration as the first node.
        doc.InsertBefore(Declaration, doc.DocumentElement)
        ' Add a comment.
        Comment = doc.CreateComment("Created with the XmlDocument class.")
        doc.InsertAfter(Comment, Declaration)

        ' Add the root node.
        RootElement = doc.CreateElement("BookList1")
        doc.InsertAfter(RootElement, Comment)

        ' Add the first product.
        ProductElement = doc.CreateElement("Product")
        RootElement.AppendChild(ProductElement)

        ' Set and add the product attributes.
        ProductAttribute = doc.CreateAttribute("ID")
        ProductAttribute.Value = "1"
        ProductElement.SetAttributeNode(ProductAttribute)

        ProductAttribute = doc.CreateAttribute("Name")
        ProductAttribute.Value = "Software Engineering"
        ProductElement.SetAttributeNode(ProductAttribute)

        ' Add the price node.
        PriceElement = doc.CreateElement("Price")
        PriceElement.InnerText = "3500"
        ProductElement.AppendChild(PriceElement)

        StatusElement = doc.CreateElement("Status")
        StatusElement.InnerText = "1"
        ProductElement.AppendChild(StatusElement)



        ' Add the second product.
        ProductElement = doc.CreateElement("Product")
        RootElement.AppendChild(ProductElement)

        ' Set and add the product attributes.
        ProductAttribute = doc.CreateAttribute("ID")
        ProductAttribute.Value = "2"
        ProductElement.SetAttributeNode(ProductAttribute)
        ProductAttribute = doc.CreateAttribute("Name")
        ProductAttribute.Value = "Data Structures"
        ProductElement.SetAttributeNode(ProductAttribute)

        ' Add the price node.
        PriceElement = doc.CreateElement("Price")
        PriceElement.InnerText = "3000"
        ProductElement.AppendChild(PriceElement)

        StatusElement = doc.CreateElement("Status")
        StatusElement.InnerText = "3"
        ProductElement.AppendChild(StatusElement)

        ' Add the third product.
        ProductElement = doc.CreateElement("Product")
        RootElement.AppendChild(ProductElement)

        ' Set and add the product attributes.
        ProductAttribute = doc.CreateAttribute("ID")
        ProductAttribute.Value = "3"
        ProductElement.SetAttributeNode(ProductAttribute)
        ProductAttribute = doc.CreateAttribute("Name")
        ProductAttribute.Value = "Programming with C"
        ProductElement.SetAttributeNode(ProductAttribute)

        ' Add the price node.
        PriceElement = doc.CreateElement("Price")
        PriceElement.InnerText = "4000"
        ProductElement.AppendChild(PriceElement)

        StatusElement = doc.CreateElement("Status")
        StatusElement.InnerText = "2"
        ProductElement.AppendChild(StatusElement)



        ' Save the document.
        doc.Save("c:\BookList1")

        lblStatus.Text = "File c:\BookList1 written successfully."

    End Sub

    Private Sub cmdDisplay_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdDisplay.Click
        ' Create the document.
        Dim doc As New XmlDataDocument()
        doc.Load("c:\BookList1")

        ' Loop through all the nodes, and create the ArrayList..
        Dim Element As XmlElement
        Dim Products As New ArrayList()
        For Each Element In doc.DocumentElement.ChildNodes
            Dim NewProduct As New Product()
            NewProduct.ID = Element.GetAttribute("ID")
            NewProduct.Name = Element.GetAttribute("Name")
            NewProduct.Price() = Element.ChildNodes(0).InnerText()
            NewProduct.Status() = Element.ChildNodes(1).InnerText()
            Products.Add(NewProduct)
        Next

        ' Display the results.
        dgResults.DataSource = Products
        dgResults.DataBind()

    End Sub

    Private Sub cmdSearch_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdSearch.Click
        Dim doc As New XmlDataDocument()
        doc.Load("c:\BookList1")
        Dim Results As XmlNodeList
        Dim Result As XmlNode

        ' Perform the search.
        Results = doc.GetElementsByTagName("Price")

        ' Display the results.
        lblStatus.Text = "<b>Found " & Results.Count.ToString() & " Matches "
        lblStatus.Text &= " for the Price tag: </b><br><br>"
        For Each Result In Results
            lblStatus.Text &= Result.FirstChild.Value & "<br>"
        Next

    End Sub
End Class
Public Class Product
    Private _ID As Integer
    Private _Name As String
    Private _Price As Decimal
    Private _Status As Integer
    Public Property Status() As Integer
        Get
            Return _Status
        End Get
        Set(ByVal Value As Integer)
            _Status = Value
        End Set
    End Property
    Public Property ID() As Integer
        Get
            Return _ID
        End Get
        Set(ByVal Value As Integer)
            _ID = Value
        End Set
    End Property

    Public Property Name() As String
        Get
            Return _Name
        End Get
        Set(ByVal Value As String)
            _Name = Value
        End Set
    End Property

    Public Property Price() As Decimal
        Get
            Return _Price
        End Get
        Set(ByVal Value As Decimal)
            _Price = Value
        End Set
    End Property

End Class