Imports System.IO
Imports System.Xml
Imports System.Xml.Schema
Public Class WebForm1
    Inherits System.Web.UI.Page
    Protected WithEvents cmdCreate As System.Web.UI.WebControls.Button
    Protected WithEvents cmdDisplay As System.Web.UI.WebControls.Button
    Protected WithEvents dgResults As System.Web.UI.WebControls.DataGrid
    Protected WithEvents cmdNodes As System.Web.UI.WebControls.Button
    Protected WithEvents lblStatus As System.Web.UI.WebControls.Label

#Region " Web Form Designer Generated Code "

    'This call is required by the Web Form Designer.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()

    End Sub

    Private Sub Page_Init(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Init
        'CODEGEN: This method call is required by the Web Form Designer
        'Do not modify it using the code editor.
        InitializeComponent()
    End Sub

#End Region

    Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        'Put user code to initialize the page here
    End Sub

    Private Sub cmdCreate_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdCreate.Click
        lblStatus.Text = ""
        Dim fs As New FileStream("d:\BookList.xml", FileMode.Create)
        Dim w As New XmlTextWriter(fs, Nothing)
        w.WriteStartDocument()
        w.WriteStartElement("BookList")
        w.WriteComment("This file generated by the XmlTextWriter class.")

        ' Write the first product.
        w.WriteStartElement("Product")
        w.WriteAttributeString("ID", "", "1")

        w.WriteAttributeString("Name", "", "Software Engineering")

        w.WriteStartElement("Price")
        w.WriteString("3500")
        w.WriteEndElement()

        w.WriteStartElement("Status")
        w.WriteString("2")
        w.WriteEndElement()

        ' Write the second product.
        w.WriteStartElement("Product")
        w.WriteAttributeString("ID", "", "2")
        w.WriteAttributeString("Name", "", "Data Structures")

        w.WriteStartElement("Price")
        w.WriteString("3000")
        w.WriteEndElement()

        w.WriteStartElement("Status")
        w.WriteString("3")
        w.WriteEndElement()

        ' Write the third product.
        w.WriteStartElement("Product")
        w.WriteAttributeString("ID", "", "3")
        w.WriteAttributeString("Name", "", "Programming With C")

        w.WriteStartElement("Price")
        w.WriteString("4000")
        w.WriteEndElement()

        w.WriteStartElement("Status")
        w.WriteString("1")
        w.WriteEndElement()

        ' Close the root element.
        w.WriteEndElement()
        w.WriteEndDocument()
        w.Close()
        lblStatus.Text = "File d:\BookList.xml written successfully."

    End Sub

    Private Sub cmdDisplay_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdDisplay.Click
        lblStatus.Text = ""

        Dim fs As FileStream
        Dim r As XmlTextReader

        ' Store retrived products in an ArrayList collection.
        Dim Products As New ArrayList()
        ' Open a stream to the file.
        fs = New FileStream("d:\BookList.xml", FileMode.Open)
        r = New XmlTextReader(fs)

        ' Loop through the products..
        Do While r.Read()
            If r.NodeType = XmlNodeType.Element And r.Name = "Product" Then
                Dim NewProduct As New Product()
                NewProduct.ID = Val(r.GetAttribute(0))
                NewProduct.Name = r.GetAttribute(1)
                ' Get the rest of the subtags for this product.
                Do Until r.NodeType = XmlNodeType.EndElement
                    r.Read()
                    If r.Name = "Price" Then
                        Do Until (r.NodeType = XmlNodeType.EndElement)
                            r.Read()
                            If r.NodeType = XmlNodeType.Text Then
                                NewProduct.Price = Val(r.Value)
                            End If
                        Loop
                    End If
                    r.Read()
                    If r.Name = "Status" Then
                        Do Until (r.NodeType = XmlNodeType.EndElement)
                            r.Read()
                            If r.NodeType = XmlNodeType.Text Then
                                NewProduct.Status = Val(r.Value)
                            End If
                        Loop
                    End If

                    ' We could check for other Product nodes
                    ' (like Available, Status, etc.) here.
                Loop

                ' Add the product
                Products.Add(NewProduct)
            End If
        Loop

        r.Close()

        ' Display the retrieved document.
        dgResults.DataSource = Products
        dgResults.DataBind()


    End Sub

    Private Sub cmdNodes_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdNodes.Click
        lblStatus.Text = ""

        Dim fs As New FileStream("d:\BookList.xml", FileMode.Open)
        Dim r As New XmlTextReader(fs)


        ' Parse the file and read each node.
        Do While r.Read()
            lblStatus.Text &= "<b>Type:</b> " & r.NodeType.ToString & "<br>"

            If r.Name <> "" Then
                lblStatus.Text &= "<b>Name:</b> " & r.Name & "<br>"
            End If

            If r.Value <> "" Then
                lblStatus.Text &= "<b>Value:</b> " & r.Value & "<br>"
            End If

            If r.AttributeCount > 0 Then
                lblStatus.Text &= "<b>Attributes:</b> "
                Dim i As Integer
                For i = 0 To r.AttributeCount() - 1
                    lblStatus.Text &= "  " & r.GetAttribute(i) & " &nbsp;&nbsp;&nbsp"
                Next
                lblStatus.Text &= "<br>"
            End If

            lblStatus.Text &= "<br>"
        Loop

        r.Close()

    End Sub
End Class
Public Class Product
    Private _ID As Integer
    Private _Name As String
    Private _Price As Decimal
    Private _Status As Integer

    Public Property Status() As Integer
        Get
            Return _Status
        End Get
        Set(ByVal Value As Integer)
            _Status = Value
        End Set
    End Property

    Public Property ID() As Integer
        Get
            Return _ID
        End Get
        Set(ByVal Value As Integer)
            _ID = Value
        End Set
    End Property

    Public Property Name() As String
        Get
            Return _Name
        End Get
        Set(ByVal Value As String)
            _Name = Value
        End Set
    End Property

    Public Property Price() As Decimal
        Get
            Return _Price
        End Get
        Set(ByVal Value As Decimal)
            _Price = Value
        End Set
    End Property
End Class