<%@ Import Namespace="System.Data.OleDb" %>
<%@ Import Namespace="System.Data" %>

<Script Runat="Server">

Dim con As OleDbConnection
Dim strSelect As String
Dim startIndex As Integer
Dim endIndex As Integer

Sub Page_Load
  Dim cmdSelect As OleDbCommand
  con = New OleDbConnection( "Provider = Microsoft.Jet.OLEDB.4.0;" & "Data Source = d:\inetpub\wwwroot\db\student.mdb" )
  If Not IsPostBack Then
    ' Get Total Pages
    strSelect = "Select Count(*)  From StTable"
    cmdSelect = New OleDbCommand( strSelect, con )
    con.Open()
    DataGrid1.VirtualItemCount = 200 
    con.Close()
    BindDataGrid
  End If
End Sub

Sub BindDataGrid
  Dim da As OleDbDataAdapter
  Dim ds As DataSet
  endIndex = startIndex + DataGrid1.PageSize
  strSelect = "Select * From StTable Where pno > @startIndex " _
    & "And pno <= @endIndex  Order By pno"
  da = New OleDbDataAdapter( strSelect, con )
  da.SelectCommand.Parameters.Add( "@startIndex", startIndex )
  da.SelectCommand.Parameters.Add( "@endIndex",  endIndex )
  ds = New DataSet
  da.Fill( ds )
  DataGrid1.DataSource = ds
  DataGrid1.DataBind()
End Sub

Sub DataGrid1_PageIndexChanged( s As Object, e As DataGridPageChangedEventArgs )
  startIndex = ( e.NewPageIndex * DataGrid1.PageSize )
  DataGrid1.CurrentPageIndex = e.NewPageIndex
  BindDataGrid
End Sub

</Script>

<html>
<head><title>DataGridCustomPaging.aspx</title></head>
<body>
<form Runat="Server">

<asp:DataGrid
  ID="DataGrid1"
  AllowPaging="True"
  AllowCustomPaging="True"
  PageSize="3"
  OnPageIndexChanged="DataGrid1_PageIndexChanged"
  PagerStyle-Mode="NumericPages"
  CellPadding="3"
  Runat="Server" />
</form>
</body>
</html>
