using System;
using System.Collections.Generic;
using System.Text;

namespace ch7_2
{
    class Circle : Point 
    {
        private double radius;
        public Circle()
        {
            Console.WriteLine("Circle Constructor : {0}", this);
        }
        public Circle(int xValue, int yValue, double radiusValue)
            : base(xValue, yValue)
        {
            radius = radiusValue;
            Console.WriteLine("Circle Constructor : {0}", this);
        }
        ~Circle()
        {
            Console.WriteLine("Circle Destructor : {0}", this);
        }
        public double Radius
        {
            get
            {
                return radius;
            }
            set
            {
               if(radius  >= 0)
                     radius = value;
            }
        }
        public double Area()
        {
            return 3.14 * Radius * Radius;
        }
        public double Circumference()
        {
            return 2 * 3.14 * Radius;
        }
        public override string ToString()
        {
            return "Center = " + base.ToString() +
                ", Radius = " + Radius;
        }

    }
}
 

