using System;
using System.Collections.Generic;
using System.Text;

namespace ch6_9
{
    class Date
    {
        private int month; // 1-12
        private int day; // 1-31 based on month
        private int year; // any year (could validate)

        // constructor: use property Month to confirm proper value for month; 
        // use property Day to confirm proper value for day
        public Date(int theMonth, int theDay, int theYear)
        {
            Month = theMonth; // validate month
            Year = theYear; // could validate year
            Day = theDay; // validate day
            Console.WriteLine("Date object constructor for date {0}", this);
        } // end Date constructor

        // property that gets and sets the year
        public int Year
        {
            get
            {
                return year;
            } // end get
            private set // make writing inaccessible outside the class
            {
                year = value; // could validate
            } // end set
        } // end property Year

        // property that gets and sets the month
        public int Month
        {
            get
            {
                return month;
            } // end get
            private set // make writing inaccessible outside the class
            {
                if (value > 0 && value <= 12) // validate month
                    month = value;
                else // month is invalid 
                {
                    Console.WriteLine("Invalid month ({0}) set to 1.", value);
                    month = 1; // maintain object in consistent state
                } // end else
            } // end set
        } // end property Month

        // property that gets and sets the day
        public int Day
        {
            get
            {
                return day;
            } // end get
            private set // make writing inaccessible outside the class
            {
                int[] daysPerMonth = 
         //   { 0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };
            { 0, 31, 31, 31, 31, 31, 31, 30, 30, 30, 30, 30, 30 };

                // check if day in range for month
                if (value > 0 && value <= daysPerMonth[Month])
                    day = value;
                // check for leap year
                else if (Month == 12 && value == 29 &&
                   (Year % 400 == 0 || (Year % 4 == 0 && Year % 100 != 0)))
                    day = value;
                else
                {
                    Console.WriteLine("Invalid day ({0}) set to 1.", value);
                    day = 1; // maintain object in consistent state
                } // end else
            } // end set
        } // end property Day 

        // return a string of the form month/day/year
     public  override  string ToString()
       {
            return string.Format("{0}/{1}/{2}", Month, Day, Year);
       } // end method ToString
       
    }
}
