using System;
using System.Collections.Generic;
using System.Text;

namespace ch6_10
{
    class Program
    {
        static void Main(string[] args)
        {
            Console.WriteLine("Employees before instantiation: {0}",
               Employee.Count);

            // create two Employees; count should become 2
            Employee e1 = new Employee("Ali", "Ahmadi");
            Employee e2 = new Employee("Reza", "Amini");

            // show that count is 2 after creating two Employees
            Console.WriteLine("\nEmployees after instantiation: {0}",
               Employee.Count);

            // get names of Employees
            Console.WriteLine("\nEmployee 1: {0} {1}\nEmployee 2: {2} {3}\n",
               e1.FirstName, e1.LastName,
               e2.FirstName, e2.LastName);

            // in this example, there is only one reference to each Employee,
            // so the following statements cause the CLR to mark each 
            // Employee object as being eligible for destruction
            e1 = null; // object e1 no longer needed
            e2 = null; // object e2 no longer needed

            GC.Collect(); // ask for garbage collection to occur now
            // wait until the destructors
            // finish writing to the console
            GC.WaitForPendingFinalizers();

            // show Employee count after calling garbage collector and
            // waiting for all destructors to finish
            Console.WriteLine("\nEmployees after destruction: {0}",
               Employee.Count);
            Console.Read();
        }
    }
}
