using System;
using System.Collections.Generic;
using System.Text;

namespace ch6_10
{
    class Employee
    {
        private string firstName;
        private string lastName;
        private static int count = 0; // number of objects in memory

        // initialize employee, add 1 to static count and 
        // output string indicating that constructor was called
        public Employee(string first, string last)
        {
            firstName = first;
            lastName = last;
            count++; // increment static count of employees
            Console.WriteLine("Employee constructor: {0} {1}; count = {2}",
               FirstName, LastName, Count);
        } // end Employee constructor

        // subtract 1 from static count when the garbage collector
        // calls destructor to clean up object;
        // confirm that destructor was called
        ~Employee()
        {
            count--; // decrement static count of employees
            Console.WriteLine("Employee destructor: {0} {1}; count = {2}",
               FirstName, LastName, Count);
        } // end destructor

        // read-only property that gets the first name
        public string FirstName
        {
            get
            {
                return firstName;
            } // end get
        } // end property FirstName

        // read-only property that gets the last name
        public string LastName
        {
            get
            {
                return lastName;
            } // end get
        } // end property LastName

        // read-only property that gets the employee count
        public static int Count
        {
            get
            {
                return count;
            } // end get
        } // end property Count

    }
}
