using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
namespace ch18_4
{
    class Consumer
    {
        private Buffer sharedLocation;
        private Random randomSleepTime;

        // constructor
        public Consumer(Buffer shared, Random random)
        {
            sharedLocation = shared;
            randomSleepTime = random;
        } // end constructor

        // read sharedLocation's value five times
        public void Consume()
        {
            int sum = 0;

            // sleep for random interval up to 3000 milliseconds then
            // add sharedLocation's Buffer property value to sum
            for (int count = 1; count <= 5; count++)
            {
                Thread.Sleep(randomSleepTime.Next(1, 3001));
                sum += sharedLocation.Buffer;
            } // end for

            Console.WriteLine(
               "{0} read values totaling: {1}.\nTerminating {0}.",
               Thread.CurrentThread.Name, sum);
        } // end method Consume
    } // end class Consumer
}
