using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
namespace Ch12_1
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private StreamReader streamToPrint;
        string fileName = "";
        Font printFont = new Font("Times New Roman", 10);
        private void Form1_Load(object sender, EventArgs e)
        {
            button1.Text = "Print";
            button2.Text = "Preview";
            button3.Text = "Print Dialog";
            button4.Text = "Page Setup";
            button5.Text = "Open";
            button6.Text = "Font";

        }

        private void button1_Click(object sender, EventArgs e)
        {

            if (fileName != "")
                printDocument1.Print();

            else
                MessageBox.Show("Please Select file with open Button");
        }

        private void button2_Click(object sender, EventArgs e)
        {
            if (fileName != "")
            {
                printDocument1.DocumentName = fileName;
                printPreviewDialog1.Document = printDocument1;
                printPreviewDialog1.ShowDialog();
             
            }
            else
                MessageBox.Show("Please Select file with open Button");printDocument1.DocumentName = fileName;
             
        }

        private void button3_Click(object sender, EventArgs e)
        {
            if (fileName != "")
            {
                printDocument1.DocumentName = fileName;
                printPreviewDialog1.Document = printDocument1;
                DialogResult result = printDialog1.ShowDialog();
                // If the result is OK then print the document.
                if (result == DialogResult.OK)
                {
                    printDocument1.Print();
                }
          
            }
            else
                MessageBox.Show("Please Select file with open Button"); printDocument1.DocumentName = fileName;
            
        }
        private void button4_Click(object sender, EventArgs e)
        {
            pageSetupDialog1.Document = printDocument1;
            pageSetupDialog1.ShowDialog();

        }
        private void button5_Click(object sender, EventArgs e)
        {
            DialogResult result = openFileDialog1.ShowDialog();
            if (result == DialogResult.OK)
            {
                fileName = openFileDialog1.FileName;
            }
        }

        private void button6_Click(object sender, EventArgs e)
        {
            DialogResult result = fontDialog1.ShowDialog();
            if (result == DialogResult.OK)
            {
                printFont = fontDialog1.Font;
            }
        }

        private void printDocument1_BeginPrint(object sender, System.Drawing.Printing.PrintEventArgs e)
        {
            streamToPrint = new StreamReader(fileName);
        }

        private void printDocument1_EndPrint(object sender, System.Drawing.Printing.PrintEventArgs e)
        {
            streamToPrint.Close();
        }

        private void printDocument1_PrintPage(object sender, System.Drawing.Printing.PrintPageEventArgs e)
        {
            float linesPerPage = 0;
            float yPos = 0;
            int count = 0;
            float leftMargin = e.MarginBounds.Left;
            float topMargin = e.MarginBounds.Top;
            string line = null;

            // Calculate the number of lines per page.
            linesPerPage = e.MarginBounds.Height / printFont.GetHeight(e.Graphics);
            // Print each line of the file.
            while (count < linesPerPage &&
               ((line = streamToPrint.ReadLine()) != null))
            {
                yPos = topMargin + (count * printFont.GetHeight(e.Graphics));
                e.Graphics.DrawString(line, printFont, Brushes.Black, leftMargin, yPos, new StringFormat());
                count++;
            }

            // If more lines exist, print another page.
            if (line != null)
                e.HasMorePages = true;
            else
            
                e.HasMorePages = false;

        }

       
    }
}