using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
namespace Ch10_3
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private const int NUMBER_OF_REC = 150;
        private FileStream input = null;
        private FileStream output = null;
        private randomAccessRecord record = new randomAccessRecord();
        private BinaryReader binaryInput;
        private BinaryWriter binaryOutput;

        private void clearTextBox()
        {
            textBox1.Clear();
            textBox2.Clear();
            textBox3.Clear();
            textBox4.Clear();
            textBox5.Clear();
            button1.Text = "Create";
            button2.Text = "Edit";
            button3.Text = "Read";
            button4.Text = "Average";
        }
        private void Form1_Load(object sender, EventArgs e)
        {
            label1.Text = "StNo:";
            label2.Text = "FName:";
            label3.Text = "LName:";
            label4.Text = "Grade:";
            textBox5.Visible = false;
            clearTextBox();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            output = new FileStream("Student.Rnd", FileMode.Create, FileAccess.Write);
            binaryOutput = new BinaryWriter(output);
            for (int i = 0; i < NUMBER_OF_REC; i++)
            {
                output.Position = i * randomAccessRecord.SIZE;
                binaryOutput.Write(record.StNo);
                binaryOutput.Write(record.fName);
                binaryOutput.Write(record.lName);
                binaryOutput.Write(record.Grade);

            }
            output.Close();
            MessageBox.Show("Random Access File Created");
        }

        private void button2_Click(object sender, EventArgs e)
        {
            if (textBox1.Text != "")
            {
                int stno = Convert.ToInt32(textBox1.Text);
                output = new FileStream("Student.Rnd", FileMode.Open, FileAccess.Write);
                binaryOutput = new BinaryWriter(output);
                if (stno > 0 && stno < NUMBER_OF_REC)
                {
                    output.Seek((stno - 1) * randomAccessRecord.SIZE, SeekOrigin.Begin);
                    binaryOutput.Write(stno);
                    record.fName = textBox2.Text;
                    record.lName = textBox3.Text;
                    record.Grade = Convert.ToDouble(textBox4.Text);
                    binaryOutput.Write(record.fName);
                    binaryOutput.Write(record.lName);
                    binaryOutput.Write(record.Grade);
                }
                else
                    MessageBox.Show("Invalid stNo");
                output.Close();
                clearTextBox();
            }
            else
                MessageBox.Show("Please enter stNo");

        }

        private void button3_Click(object sender, EventArgs e)
        {
            if (textBox1.Text != "")
            {
                input = new FileStream("Student.Rnd", FileMode.Open, FileAccess.Read);
                binaryInput = new BinaryReader(input);
                int stno = Convert.ToInt32(textBox1.Text);
                if (stno > 0 && stno < NUMBER_OF_REC)
                {
                    input.Seek((stno - 1) * randomAccessRecord.SIZE, 0);
                    record.StNo = binaryInput.ReadInt32();
                    record.fName = binaryInput.ReadString();
                    record.lName = binaryInput.ReadString();
                    record.Grade = binaryInput.ReadDouble();
                    textBox2.Text = record.fName;
                    textBox3.Text = record.lName;
                    textBox4.Text = record.Grade.ToString();
                }
                else
                    MessageBox.Show("Invalid stNo");
                input.Close();
            }
            else
                MessageBox.Show("Please enter stNo");
        }

        private void button4_Click(object sender, EventArgs e)
        {
            textBox5.Visible = true;
            input = new FileStream("Student.Rnd", FileMode.Open, FileAccess.Read);
            binaryInput = new BinaryReader(input);
            double sum = 0;
            int count = 0;
            textBox5.Text = " Student are :";
            for (int i = 0; i < NUMBER_OF_REC; i++)
            {

                input.Seek((i) * randomAccessRecord.SIZE, 0);
                record.StNo = binaryInput.ReadInt32();
                record.fName = binaryInput.ReadString();
                record.lName = binaryInput.ReadString();
                record.Grade = binaryInput.ReadDouble();
                if (record.StNo != 0)
                {

                    sum += record.Grade;
                    count++;
                    string result = record.StNo.ToString() + "\t" + record.fName + "\t" + record.lName + "\t" + record.Grade.ToString();
                    textBox5.Text += "\r\n" + result;
                }
            }
            textBox5.Text += "\r\n" + "====================================";
            textBox5.Text += "\r\n" + "Average is: " + Convert.ToString((sum / count));
		
        }
    }
}