using System;
using System.Collections.Generic;
using System.Text;

namespace ch6_14
{
    class Student
    {
   private string[] names = { "ali", "ahmad", "reza" };
   private double[] average = new double[ 3 ];

   // constructor
   public Student( double ali, double ahmad, double reza )
   {
      average[ 0 ] = ali;
      average[ 1 ] = ahmad;
      average[ 2 ] = reza;
   }

   // indexer to access average by integer index number
   public double this[ int index ]
   {
      get
      {
         // validate index to get
         if ( ( index < 0 ) || ( index >= average.Length ) )
            return -1;
         else
            return average[ index ];
      } // end get
      set
      {
         if ( index >= 0 && index < average.Length )
            average[ index ] = value;
      } // end set
   } // end numeric indexer

   // indexer to access average by their string names
   public double this[ string name ]
   {
      get
      {
         // locate element to get
         int i = 0;

         while ( ( i < names.Length ) &&
            ( name.ToLower() != names[ i ] ) )
            i++;

         return ( i == names.Length ) ? -1 : average[ i ];
      } // end get
      set
      {
         // locate element to set
         int i = 0;

         while ( ( i < names.Length ) &&
            ( name.ToLower() != names[ i ] ) )
            i++;

         if ( i != names.Length )
            average[ i ] = value;
      } // end set
   } // end string indexer

    }
}
