using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;

namespace ch18_4
{
    class Program
    {
        // create producer and consumer threads and start them
        static void Main(string[] args)
        {
            // create shared object used by threads
            SynchronizedBuffer shared = new SynchronizedBuffer();

            // Random object used by each thread
            Random random = new Random();

            // output column heads and initial buffer state
            Console.WriteLine("{0,-35}{1,-9}{2}\n",
               "Operation", "Buffer", "Occupied Count");
            shared.DisplayState("Initial state");

            // create Producer and Consumer objects
            Producer producer = new Producer(shared, random);
            Consumer consumer = new Consumer(shared, random);

            // create threads for producer and consumer and set 
            // delegates for each thread
            Thread producerThread =
               new Thread(new ThreadStart(producer.Produce));
            producerThread.Name = "Producer";

            Thread consumerThread =
               new Thread(new ThreadStart(consumer.Consume));
            consumerThread.Name = "Consumer";

            // start each thread
            producerThread.Start();
            consumerThread.Start();
            Console.Read();
        } // end Main



    }
}
