using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;

namespace ch18_4
{
    class Producer
    {
        private Buffer sharedLocation;
        private Random randomSleepTime;

        // constructor
        public Producer(Buffer shared, Random random)
        {
            sharedLocation = shared;
            randomSleepTime = random;
        } // end constructor

        // store values 1-5 in object sharedLocation
        public void Produce()
        {
            // sleep for random interval up to 3000 milliseconds
            // then set sharedLocation's Buffer property
            for (int count = 1; count <= 5; count++)
            {
                Thread.Sleep(randomSleepTime.Next(1, 3001));
                sharedLocation.Buffer = count;
            } // end for

            Console.WriteLine("{0} done producing.\nTerminating {0}.",
               Thread.CurrentThread.Name);
        } // end method Produce
    } // end class Producer
}
