using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Ch8_2
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }
        String fileName;
        String cutText;
        bool modified;

        private bool saveChange()
        {
            bool saveCh = true;
            DialogResult code;
            code = MessageBox.Show("The Information " + fileName + " has changed,save?", "Save Dialog", MessageBoxButtons.YesNoCancel);
            if (code == DialogResult.Yes) saveCh = save1();
            if (code == DialogResult.Yes) saveCh = false;
            return saveCh;
        }
        private bool save1()
        {
            if (fileName == "")
                return saveAs1();
            else
            {
                modified = false;
                RichTextBox1.SaveFile(fileName);
                return true;
            }
        }
        private bool saveAs1()
        {
            saveFileDialog1.Filter = "*.txt |*.txt";
            saveFileDialog1.Title = "Select File Name For Save";
            saveFileDialog1.FileName = fileName;
            saveFileDialog1.ShowDialog();
            fileName = saveFileDialog1.FileName;
            RichTextBox1.SaveFile(fileName);

            return true;
        }
        private void Form1_Load(object sender, EventArgs e)
        {
            RichTextBox1.ContextMenuStrip = ContextMenuStrip1;
            RichTextBox1.Text = " ";
            fileName = "";
            modified = false;
            PasteToolStripMenuItem.Enabled = false;
            CopyToolStripMenuItem.Enabled = false;
            ClearToolStripMenuItem.Enabled = false;
            helpProvider1.HelpNamespace = "d:\\c#new\\8\\help.htm";
        }

        private void NewToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (modified)
                saveChange();
            RichTextBox1.Clear();
            modified = false;
            fileName = "";
            this.Text = "Notes-[Untitled]";
        }

        private void RichTextBox1_TextChanged(object sender, EventArgs e)
        {
            modified = true;
            if (RichTextBox1.SelectedText != "" || cutText != "")
            {
                CutToolStripMenuItem.Enabled = true;
                CopyToolStripMenuItem.Enabled = true;
            }					
		
        }

        private void OpenToolStripMenuItem_Click(object sender, EventArgs e)
        {
            openFileDialog1.Filter = "*.txt|*.txt";
            openFileDialog1.Title = "Select File Name For Open";
            openFileDialog1.FileName = fileName;
            openFileDialog1.ShowDialog();
            fileName = openFileDialog1.FileName;
            RichTextBox1.LoadFile(fileName);
            this.Text = "Notes-" + fileName;
        }

        private void SaveToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (modified)
            {
                save1();
                modified = false;
            }
            this.Text = "Notes-" + fileName;
		

        }

        private void SaveAsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (modified)
            {
                save1();
                modified = false;
            }
            this.Text = "Notes-" + fileName;
		
        }

        private void ExitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (modified) save1();
            Close();

        }

        private void CutToolStripMenuItem_Click(object sender, EventArgs e)
        {
            cutText = RichTextBox1.SelectedText;
            RichTextBox1.Cut();
            RichTextBox1.SelectedText = "";
            PasteToolStripMenuItem.Enabled = true;
		
        }

        private void CopyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            cutText = RichTextBox1.SelectedText;
            RichTextBox1.Focus();
            RichTextBox1.Copy();
            PasteToolStripMenuItem.Enabled = true;
            CopyToolStripMenuItem.Enabled = false;
            CutToolStripMenuItem.Enabled = false;
            ClearToolStripMenuItem.Enabled = false;
        }

        private void PasteToolStripMenuItem_Click(object sender, EventArgs e)
        {
            RichTextBox1.Paste();
            RichTextBox1.Refresh();
            CopyToolStripMenuItem.Enabled = false;
            CutToolStripMenuItem.Enabled = false;
            ClearToolStripMenuItem.Enabled = false;
		
        }

        private void ClearToolStripMenuItem_Click(object sender, EventArgs e)
        {
            RichTextBox1.SelectedText = "";
            CopyToolStripMenuItem.Enabled = false;
            CutToolStripMenuItem.Enabled = false;
            ClearToolStripMenuItem.Enabled = false;
		
        }

        private void FontToolStripMenuItem_Click(object sender, EventArgs e)
        {
            DialogResult result;
            result = fontDialog1.ShowDialog();
            if (result == DialogResult.OK)
                RichTextBox1.Font = fontDialog1.Font;
        }

        private void ColorToolStripMenuItem_Click(object sender, EventArgs e)
        {
            DialogResult result;
            result = colorDialog1.ShowDialog();
            if (result == DialogResult.OK)
                RichTextBox1.BackColor = colorDialog1.Color;
        }

        private void ReadOnlyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ReadOnlyToolStripMenuItem.Checked = !ReadOnlyToolStripMenuItem.Checked;
            RichTextBox1.ReadOnly = !RichTextBox1.ReadOnly;

        }

        private void AboutToolStripMenuItem_Click(object sender, EventArgs e)
        {
            MessageBox.Show("The notes program has been writeln C# .NET");
        }

        private void toolStripButton1_Click(object sender, EventArgs e)
        {
            AboutToolStripMenuItem_Click(this, e);
        }

        private void toolStripButton2_Click(object sender, EventArgs e)
        {
            ColorToolStripMenuItem_Click(sender, e);
        }

        private void CSave_Click(object sender, EventArgs e)
        {
            SaveToolStripMenuItem_Click(sender, e);
 
        }

        private void CCopy_Click(object sender, EventArgs e)
        {
            CopyToolStripMenuItem_Click(sender, e);
    
        }

        private void RichTextBox1_SelectionChanged(object sender, EventArgs e)
        {
            if (RichTextBox1.SelectedText != "")
            {
                CutToolStripMenuItem.Enabled = true;
                CopyToolStripMenuItem.Enabled = true;
                ClearToolStripMenuItem.Enabled = true;
            }
      
        }
    }
}