﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Ch14_1
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }
        private void InitMenu()
        {
            playToolStripMenuItem.Enabled = false;
            nextToolStripMenuItem.Enabled = false;
            backToolStripMenuItem.Enabled = false;
            stepToolStripMenuItem.Enabled = false;
            stopToolStripMenuItem.Enabled = false;
            ejectToolStripMenuItem.Enabled = false;
            pauseToolStripMenuItem.Enabled = false;
        }

        private void Select_Device(string ext)
        {
            if (ext == "WAV")
            {
                axMMControl1.DeviceType = "WaveAudio";
                pictureBox1.Visible = false;
            }
            else if (ext == "AVI")
            {
                axMMControl1.DeviceType = "AviVideo";
                pictureBox1.Visible = true;
            }
            else if (ext == "MMM")
            {
                axMMControl1.DeviceType = "MMMovie";
                pictureBox1.Visible = true;
            }
        }


        private void Form1_Load(object sender, EventArgs e)
        {
            InitMenu();
        }

        private void openToolStripMenuItem_Click(object sender, EventArgs e)
        {
            openFileDialog1.Filter = "All Files |*.*";
            openFileDialog1.ShowDialog();
            axMMControl1.Command = "Close";
            if (openFileDialog1.FileName != "")
            {
                int l = openFileDialog1.FileName.Length;
                string ext = openFileDialog1.FileName.Substring(l - 3, 3).ToUpper();
                Select_Device(ext);
                axMMControl1.FileName = openFileDialog1.FileName;
                axMMControl1.Notify = true;
                axMMControl1.Wait = true;
                axMMControl1.Shareable = false;
                axMMControl1.Command = "Close";
                axMMControl1.Command = "Open";
                playToolStripMenuItem.Enabled = true;
                nextToolStripMenuItem.Enabled = true;
                backToolStripMenuItem.Enabled = true;
                stepToolStripMenuItem.Enabled = true;

            }
        }

        private void playToolStripMenuItem_Click(object sender, EventArgs e)
        {
            axMMControl1.Command = "Play";
            openToolStripMenuItem.Enabled = false;
            stopToolStripMenuItem.Enabled = true;
            ejectToolStripMenuItem.Enabled = true;
            pauseToolStripMenuItem.Enabled = true;
            backToolStripMenuItem.Enabled = true;
            stepToolStripMenuItem.Enabled = true;
            exitToolStripMenuItem.Enabled = true;
        }

        private void nextToolStripMenuItem_Click(object sender, EventArgs e)
        {
            axMMControl1.Command = "Prev";
            axMMControl1.Command = "Stop";
            openToolStripMenuItem.Enabled = true;
     
        }

        private void backToolStripMenuItem_Click(object sender, EventArgs e)
        {
            axMMControl1.Command = "Back";
            axMMControl1.Command = "Stop";
            openToolStripMenuItem.Enabled = true;
     
        }

        private void stepToolStripMenuItem_Click(object sender, EventArgs e)
        {
            axMMControl1.Command = "Step";
            axMMControl1.Command = "Stop";
            openToolStripMenuItem.Enabled = true;
     
        }

        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            axMMControl1.Command = "Stop";
            Close();
	
        }

        private void stopToolStripMenuItem_Click(object sender, EventArgs e)
        {
            axMMControl1.Command = "Stop";
            openToolStripMenuItem.Enabled = true;
       
        }

        private void ejectToolStripMenuItem_Click(object sender, EventArgs e)
        {
            axMMControl1.Command = "Stop";
            axMMControl1.Command = "Eject";
            openToolStripMenuItem.Enabled = true;
     	
        }

        private void pauseToolStripMenuItem_Click(object sender, EventArgs e)
        {
            axMMControl1.Command = "Pause";
            openToolStripMenuItem.Enabled = true;
            stopToolStripMenuItem.Enabled = true;
            pauseToolStripMenuItem.Enabled = false;
     
        }

    }
}
