unit a6;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,printers;

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    OpenDialog1: TOpenDialog;
    FontDialog1: TFontDialog;
    print: TButton;
    font: TButton;
    exit: TButton;
    procedure FormCreate(Sender: TObject);
    procedure fontClick(Sender: TObject);
    procedure exitClick(Sender: TObject);
    procedure printClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
  var
   fontsize,page,x,line,linepage,linespace:integer;
  {$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  {size:=fontdialog1.font.size;}
  edit1.text:='';
  edit1.readonly:=true;
  edit1.tabstop:=false;
  caption:='printing  file';
end;

procedure TForm1.printClick(Sender: TObject);
  var
     f:textfile;
     str:string;
     hi:integer;
begin
 if opendialog1.execute  then
  begin
    assignfile(f,opendialog1.FileName);
    edit1.text:='   printing file  '+opendialog1.filename;
    reset(f);
    x:=0;
    page:=1;
    line:=0;
    printer.BeginDoc;
    hi:=printer.pageheight;
    printer.canvas.font.size:=fontdialog1.font.size;
    printer.canvas.font.name:=fontdialog1.font.name;
    printer.canvas.font.Style :=fontdialog1.font.style;
    linepage:=hi div fontsize+10;
    linespace:=hi div linepage;
   while not eof(f) do
     begin
        readln(f,str);
        printer.canvas.textout(0,x,str);
        x:=x+linespace;
        line:=line+1;
        if  line>linepage-1 then
           begin
             x:=0;
             line:=1;
             printer.newpage;
           end;
     end;
   closefile(f);
   printer.enddoc;
   edit1.text:='     printing complete';
 end;
end;

procedure TForm1.exitClick(Sender: TObject);
begin
  close;
end;

procedure TForm1.fontClick(Sender: TObject);
begin
  fontdialog1.execute ;
  fontsize:=fontdialog1.Font.Size;

  end;

end.
