unit a3;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, CheckLst, FileCtrl;

type
  TForm1 = class(TForm)
    filename: TEdit;
    readonly: TCheckBox;
    hidden: TCheckBox;
    system: TCheckBox;
    archive: TCheckBox;
    Label1: TLabel;
    DirectoryListBox1: TDirectoryListBox;
    DriveComboBox1: TDriveComboBox;
    FileListBox1: TFileListBox;
    ok: TButton;
    save: TButton;
    exit: TButton;
    setall: TButton;
    clearall: TButton;
    procedure okClick(Sender: TObject);
    procedure saveClick(Sender: TObject);
    procedure exitClick(Sender: TObject);
    procedure setallClick(Sender: TObject);
    procedure clearallClick(Sender: TObject);
    procedure DriveComboBox1Change(Sender: TObject);
    procedure DirectoryListBox1Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
 var
   filename1:string;
   attrib:integer;
{$R *.DFM}

procedure TForm1.okClick(Sender: TObject);
begin
filename1:=filename.text;
attrib:=filegetattr(filename1);
if attrib and fareadonly= fareadonly then
    readonly.checked:=true
else
    readonly.checked:=false;
if attrib and faarchive= faarchive then
    archive.checked:=true
else
    archive.checked:=false;
if attrib and fasysfile= fasysfile then
    system.checked:=true
else
    system.checked:=false;
if attrib and fahidden= fahidden then
    hidden.checked:=true
else
    hidden.checked:=false;

end;

procedure TForm1.saveClick(Sender: TObject);
begin
attrib:=attrib xor attrib;
if readonly.checked=true then
   attrib := attrib or fareadonly;
if system.checked=true then
   attrib := attrib or fasysfile;
if hidden.checked=true then
   attrib := attrib or fahidden;
if archive.checked=true then
   attrib := attrib or faarchive;
filesetattr(filename1,attrib);
end;

procedure TForm1.setallClick(Sender: TObject);
begin
 attrib:=0;
 attrib:=attrib or fareadonly or fasysfile or faarchive or fahidden;
 readonly.checked:=true;
 hidden.checked:=true;
 system.checked:=true;
 archive.checked:=true;
end;

procedure TForm1.clearallClick(Sender: TObject);
begin
 attrib:=0;
 readonly.checked:=false;
 hidden.checked:=false;
 system.checked:=false;
 archive.checked:=false;

end;
procedure TForm1.exitClick(Sender: TObject);
begin
close;
end;

procedure TForm1.DriveComboBox1Change(Sender: TObject);
begin
 drivecombobox1.dirlist:=directorylistbox1;
end;

procedure TForm1.DirectoryListBox1Change(Sender: TObject);
begin
 DirectoryListBox1.filelist:=filelistbox1;
end;

end.
