unit a4;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, FileCtrl;

type
  TForm1 = class(TForm)
    FileListBox1: TFileListBox;
    DirectoryListBox1: TDirectoryListBox;
    DriveComboBox1: TDriveComboBox;
    makedir: TButton;
    deletedir: TButton;
    erasefile: TButton;
    renamefile: TButton;
    close: TButton;
    sizedisk: TButton;
    freespace: TButton;
    procedure FormCreate(Sender: TObject);
    procedure makedirClick(Sender: TObject);
    procedure deletedirClick(Sender: TObject);
    procedure erasefileClick(Sender: TObject);
    procedure sizediskClick(Sender: TObject);
    procedure freespaceClick(Sender: TObject);
    procedure closeClick(Sender: TObject);
    procedure renamefileClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
procedure input(const  s1,s2:string;var s:string);
 begin
   s:=inputbox(s1,s2,s);
 end;

procedure TForm1.FormCreate(Sender: TObject);
begin
 drivecombobox1.dirlist:=directorylistbox1;
 directorylistbox1.filelist:=filelistbox1;

end;

procedure TForm1.makedirClick(Sender: TObject);
   var
      dirname:string;
begin
   dirname:='';
   input('make directory box','directory name',dirname);
if  not directoryexists(dirname) then
   mkdir(dirname)
 else
    showmessage(' dirctory already exists ');

end;

procedure TForm1.deletedirClick(Sender: TObject);
    var
     dirname:string;
begin
 dirname:='';
 input('delete directory box','directory name',dirname);
if   directoryexists(dirname) then
     rmdir(dirname)
 else
    showmessage(' dirctory not exists ');
end;

procedure TForm1.erasefileClick(Sender: TObject);
  var
     f:textfile;
     filename:string;
begin
    filename:='';
    filename:=filelistbox1.filename;
    if fileexists(filename) then
    begin
       assignfile(f,filename);
       erase(f);
  end
  else
      showmessage(' file  not  selected ');
end;

procedure TForm1.sizediskClick(Sender: TObject);
  var
   total:integer;
begin
   total:=disksize(0);
   showmessage(' size of disk is  :  '+floattostr(total/(1024.0*1204))+ ' Mb');
end;

procedure TForm1.freespaceClick(Sender: TObject);
  var
   free:integer;
begin
   free:=diskfree(0);
   showmessage(' size of disk free is  :  '+floattostr(free/(1024.0*1204))+ ' Mb');
end;

procedure TForm1.closeClick(Sender: TObject);
begin
 application.terminate;
end;

procedure TForm1.renamefileClick(Sender: TObject);
var
     f:textfile;
     oldname,newname:string;
begin
  oldname:='';
  oldname:=filelistbox1.filename;
  if fileexists(oldname) then
    begin
    assignfile(f,oldname);
    newname:='';
    input('rename new file box ','enter new name ',newname);
     rename(f,newname);
  end
  else
      showmessage(' file  not  selected ');
 end;

end.
