unit a5;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    Label1: TLabel;
    drawpoly: TButton;
    exit: TButton;
    procedure drawpolyClick(Sender: TObject);
    procedure exitClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.drawpolyClick(Sender: TObject);
const max=20;
var
  red,green,blue:byte;
  n,i:integer;
  parray:array [0..max] of tpoint;
begin
   red   := random(255);
   green := random(255);
   blue  := random(255);
   canvas.pen.color:=red or (green shl 8)  or (blue  shl 16);
   canvas.pen.width:=2;
   n:=strtoint(edit1.text);
   if n<3 then n:=3;
   if n >max  then n:=max;
   for i:=0 to n do
     begin
        parray[i]:=point(trunc(sin((2*pi)*i/n)*120)+(form1.width div  2)+25,
               trunc(cos((2*pi)*i/n)*120)+(form1.height div  2)-10)

    end;
    for i:=n+1  to max   do
      parray[i]:=parray[0];
      canvas.polyline(parray);
end;

procedure TForm1.exitClick(Sender: TObject);
begin
 close;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
 edit1.text:='3';
end;

end.
