unit a2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Menus;

type
  TForm1 = class(TForm)
    memo1: TMemo;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    new1: TMenuItem;
    N1: TMenuItem;
    save1: TMenuItem;
    saveAS1: TMenuItem;
    N2: TMenuItem;
    eXit1: TMenuItem;
    options1: TMenuItem;
    font1: TMenuItem;
    backcolor1: TMenuItem;
    countbytes1: TMenuItem;
    N4: TMenuItem;
    help1: TMenuItem;
    aboart1: TMenuItem;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    open1: TMenuItem;
    ColorDialog1: TColorDialog;
    FontDialog1: TFontDialog;
    readonly1: TMenuItem;
    FontDialog2: TFontDialog;
    edit1: TMenuItem;
    cut1: TMenuItem;
    copy1: TMenuItem;
    past1: TMenuItem;
    clear1: TMenuItem;
    procedure FormCreate(Sender: TObject);
 {   procedure countbytes1Click(Sender: TObject);}
  {  procedure readoln1Click(Sender: TObject);}
    procedure new1Click(Sender: TObject);
{    procedure OpenDialog1CanClose(Sender: TObject; var CanClose: Boolean);
    procedure SaveDialog1CanClose(Sender: TObject; var CanClose: Boolean);}
    procedure save1Click(Sender: TObject);
    procedure saveAS1Click(Sender: TObject);
    procedure open1Click(Sender: TObject);
    procedure eXit1Click(Sender: TObject);
    procedure font1Click(Sender: TObject);
    procedure backcolor1Click(Sender: TObject);
    procedure readonly1Click(Sender: TObject);
    procedure countbytes1Click(Sender: TObject);
    procedure memo1Change(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure aboart1Click(Sender: TObject);
    procedure edit1Click(Sender: TObject);
    procedure cut1Click(Sender: TObject);
    procedure copy1Click(Sender: TObject);
    procedure past1Click(Sender: TObject);
    procedure clear1Click(Sender: TObject);

    {procedure formclosequery(Sender: TObject; var CanClose: Boolean);}

  private
    { Private declarations }
    modified:bool;
    filename:string;

  public
    { Public declarations }
   function   save:boolean;
   function   saveas:boolean;
   function   savechanges:boolean;

  end;

var
  Form1: TForm1;

implementation
   const
     paste1:boolean=false;
 {$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  past1.enabled:=false;
  memo1.clear;
  filename:='';
  modified:=false;
end;

procedure TForm1.new1Click(Sender: TObject);
begin
 if not modified or savechanges   then
    begin
      memo1.text:='';
      modified:=false;
      filename:='';
      form1.caption:='notes-[untitled]';
    end;
 end;
 function tform1.savechanges:boolean;
  var
     code:integer;
  begin
   savechanges:=true;
   code:=messagedlg('the information '+filename+
   'has changed. saved?',mtconfirmation,mbyesnocancel,0);
   if (code=IDYES) then  savechanges:=save;
   if (code=IDCANCEL) then  savechanges:=false;
  end;
function tform1.save:boolean;
  begin
  if filename='' then
      save:=saveas
  else
   begin
    modified:=false;
    memo1.lines.savetofile(filename);
    save:=true;
   end;
  end;

function tform1.saveas:boolean;
  begin
   savedialog1.filename:=filename;
   if  savedialog1.execute then
     begin
       filename:=savedialog1.filename;
       memo1.lines.savetofile(filename);
       modified:=false;
       form1.caption:='notes -'+filename;
       saveas:=true;
      end
     else
     saveas:=false;
end;

procedure TForm1.save1Click(Sender: TObject);
begin
  if modified then
    save;
end;

procedure TForm1.saveAS1Click(Sender: TObject);
begin
  saveas;
end;

procedure TForm1.open1Click(Sender: TObject);
begin
 if not modified or savechanges then
   if  opendialog1.execute then
     begin
       filename:=opendialog1.filename;
       form1.caption:='notes - '+filename;
       memo1.Lines.loadfromfile(filename);
       modified:=false;
     end;
end;

procedure TForm1.eXit1Click(Sender: TObject);
begin
  close;
end;

procedure TForm1.font1Click(Sender: TObject);
begin
   fontdialog1.font:=memo1.font;
   if fontdialog1.execute then
      memo1.font:=fontdialog1.font;
end;

procedure TForm1.backcolor1Click(Sender: TObject);
begin
   colordialog1.color:=memo1.color;
   if  colordialog1.execute then
      memo1.color:=colordialog1.color;
end;

procedure TForm1.readonly1Click(Sender: TObject);
begin
   memo1.readonly:=not memo1.readonly;
   readonly1.checked:= not readonly1.checked;
end;

procedure TForm1.countbytes1Click(Sender: TObject);
  var   str1:string;
begin
   str(memo1.GetTextLen,str1);
   showmessage('the text has '+str1+'  bytes');
end;

procedure TForm1.memo1Change(Sender: TObject);
begin
  modified:=true;
end;

procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  if modified then
    if  savechanges then
       canclose:=true
     else
     canclose:=false
   else
    canclose:=true;
 end;

procedure TForm1.aboart1Click(Sender: TObject);
begin
  showmessage(' the notes program has been written '+
                'with delphi' );
end;

procedure TForm1.edit1Click(Sender: TObject);
begin
 if paste1 then past1.enabled:=true;
 if memo1.sellength>0  then
   begin
     copy1.enabled:=true;
     cut1.enabled:=true;
     clear1.enabled:=true;
   end
else
  begin
     copy1.enabled:=false;
     cut1.enabled:=false;
     clear1.enabled:=false;
  end;
end;

procedure TForm1.cut1Click(Sender: TObject);
begin
 paste1:=true;
 memo1.cuttoclipboard;
end;

procedure TForm1.copy1Click(Sender: TObject);
begin
 paste1:=true;
 memo1.copytoclipboard;
end;

procedure TForm1.past1Click(Sender: TObject);
begin
 memo1.pastefromclipboard;
end;

procedure TForm1.clear1Click(Sender: TObject);
begin
 memo1.clearselection;
end;

end.
