; 
  name   lib
  public   cls ,disp_message,convert_num_string,get_num,move_cursor

lib        segment  para  'code'
              assume   cs:lib
;************************************
;************************************
cls   proc       far
         push      ax
         push      bx
         push      dx
         pushf   
         mov      ah, 6h   ;clear screen
         mov      al, 25   ;number of rows
         mov      ch, 0
         mov      cl, 0
         mov      dh, 24   ;row
         mov      dl, 79   ;column
         mov      bh, 7    ;attribute
         int      10h
         popf
         pop      dx
         pop      bx
         pop      ax
         
         retf

cls   endp
;************************************
;************************************
move_cursor    proc    far
         push     bp
         mov      bp, sp
         push      ax
         push      bx
         push      dx
         pushf
         mov      ah, 2h                 ;cursor move
         mov      bx,word ptr [bp+06]
         mov      dh, bh                ;row
         mov      dl, bl                ;column
         mov      bx, 0                  ;page number
         int      10h
         popf
         pop      dx
         pop      bx
         pop      ax
         pop      bp
      retf  2     
move_cursor    endp
         
;************************************
;************************************
disp_message    proc    far
         push    bp
         mov     bp, sp
         push     ax
         push     dx
         mov      dx, [bp+06]
         mov      ah, 9h
         int      21h
         pop      dx
         pop      ax
         
         pop       bp
       retf    2    
  disp_message    endp           
;*********************************************
;*********************************************
get_num       proc       far       
            push    bp 
            mov     bp, sp
            push      si 
            push      bx
            push      cx
            push      dx

            
            mov     ah, 3fh
            mov     dx, [bp+06] 
            mov     bx, 0000h
            mov     cx,8
            int     21h

              
              mov      si, dx 
while_blank:  cmp      byte ptr [bx], ' '        ; skip leading blank
              jne      end_while_blank   ; exit while
              inc      bx
              jmp      while_blank
end_while_blank:
              mov      bl, 1               ;default sign multiplier
              cmp      byte ptr [si], '+'  ;leadin + ?
              je       skip_sign           ;if so skip over
              cmp      byte ptr [si], '-'  ;leading - ?
              jne      save_sign           ;if not save default +
              mov      bl, -1              ;-1 for minus sign
skip_sign:    inc      si                  ;past sign

save_sign:    mov      ax, 0               ;number being accumulated
              mov      bh, 0               ;count of digits so far
while_digit:  cmp      byte ptr [si], '0'  ;compare next car to '0'
              jl       end_while_digit     ;if not a digit exit
              cmp      byte ptr [si], '9'  ;compare to '9'
              jg       end_while_digit     ;not a digit if bigger than '9'
              mov      cx, 10              ;multiplier
              mul      cx                  ;multiply old number by 10
              mov      cl, [si]            ;mov ascii char to bl
              and      cx, 000fh           ;convert to single digit integer
              add      ax, cx              ;add to sum
              inc      bh               ;increment digit count
              inc      si                  ;increment character pointer
              jmp      while_digit         ;go next char
end_while_digit:
              ; imul      bl
               cmp        bl, 1
               je         exit1
               neg        ax
            exit1:
            ;   mov       num, ax
              
              pop      dx
              pop      bx
              pop      cx
              pop      si 
              pop       bp

               retf 2
get_num        endp




;******************************************************
;;;;;;;;;;;;;convert number in ax to string;;;;;;;;;;;;
;******************************************************
convert_num_string   proc      far

              push      bp
              mov       bp, sp
              push      si 
              push      ax
              push      bx
              push      cx
              push      dx
              mov      ax, word ptr[bp+08]
              mov      si, word ptr[bp+06]

              add      si, 5
              mov      bh, ' '
              cmp      ax, 0
              jge      setup         ; skip if not negative
              mov      bh, '-'
              neg      ax            ; now ax > 0

setup:        mov      cx, 10        ; divisor
divloop:      mov      dx, 0         ; extend number to double word
              div      cx            ; divide by 10
              add      dl, 30h       ; convert
              mov      [si], dl
              dec      si
              cmp      ax, 0
              jne      divloop
              mov      cl, bh       ; insert sign to string
              mov      [si], cl
              
              pop      dx
              pop      bx
              pop      cx
              pop      ax
              pop      si
              pop       bp
              
              retf     4

convert_num_string   endp
;************************************
;************************************
;write_list       proc     far          
;               
;               push      bp
;               mov       bp, sp 
;               
;               push      cx
;               push      di
;               push      bx
;               mov       bx, [bp+8]
;               mov       cx, [bp+6]
;               mov       di, 0
;           loop_write:   
;               push     [bx+di] 
;               push     offset string   
;               call     convert_num_string 
;               
;               push      offset string
;               call     disp_message  
;               
;              
;              add      di, 2                  ;si<---- si+2
;              loop     loop_write                ; if   cx >0  then cx=cx-1;goto loop_write 
;              pop      bx
;              pop      di
;              pop      cx
;              pop      bp
;         retf   4
;write_list    endp
;
;************************************
;************************************
;read_list       proc        far       
;              push      bp 
;              mov       bp, sp
;              push      di
;              push      ax
;              mov       di, 0
;              mov       byte ptr rowcol+1, 5
;              mov       byte ptr rowcol, 30
;               
;           loop_read:   
;              
;               push     rowcol
;               call     move_cursor    
;              
;              push      offset mesg1 
;              call     disp_message 
;              
;              push     offset buffer
;              call     get_num        ;read  a number
;              
;              cmp      ax, 0
;              jl       loop_read
;             
;              mov       list[di], ax       ;list[counter]<--- ax
;              add       di, 2              ;si<---- si+2
;              inc      counter             ;increment  counter
;              inc      byte ptr rowcol+1 
;              cmp      counter, 10          ; compare  counter and 10   
;             jle      loop_read                ; if   counter <=10
;              pop      ax
;              pop      di
;         ret
;read_list    endp


lib        ends
              end      


