Title       a EXE program for right adjusting name
stk         segment   stack
     db   64  dup (' ')
stk         ends

datasg      segment  para 'data'
;********************************
parname     label     byte      ;name parameter list
 max        db        31        ;maximum length of name
 len        db        ?         ;actual length
 namestr    db        31 dup(),"$"  ;name
msg1        db      'Enter name: $'
namedis     db       31 dup (' '), 13, 10, '$'
row         db       0
datasg      ends
;********************************
codesg      segment  para  'code'
main        proc     far 
            assume   ds:datasg, cs:codesg, ss: stk
            .386
            mov      ax, datasg
            mov      ds, ax
            mov      es, ax
            mov      ax, 0600h
            call     clrscr        ;clear screen
            mov      dx, 0        ;set cursor to 0, 0
            call     locate
 loop1:
            call     nameinput     ;input name
            cmp      len, 0        ;no name?
            je       p1
            call     justright     ;right adjust
            call     clrname       ;clear name
            jmp      loop1
p1:
            mov      ax, 4c00h
            int      21h
main        endp
;********************************
nameinput   proc     near
            mov      ah, 09h
            lea      dx, msg1      ;display message
            int      21h
            mov      ah, 0ah
            lea      dx, parname   ;accept input
            int      21h
            ret
nameinput   endp
;********************************
justright   proc     near
            std                     ;right to left
            movzx    cx, len        ;length in cx for rep
            lea      si, namestr    ;calculate rightmost
            add      si, cx         ;position
            dec      si             ;of input name
            lea      di, namedis+30 ;right position of display name
            rep      movsb          ;mov string right to left
            mov      dh, row        ;set row in dh
            mov      dl, 48         ;set col
            call     locate         ;set cursor

            mov      ah, 09h
            lea      dx, namedis    ;display name
            int      21h
            cmp      row, 20        ;bottom of screen
            jae      p3             ;no,
            inc      row            ;next row
            jmp      p4

p3:         mov      ax, 0601h      ;yes,
            call     clrscr         ;scroll and
            mov      dh, row        ;set row
            mov      dl, 0          ;set col
            call     locate
p4:         ret
justright   endp
;********************************
clrname     proc     near
            cld                     ;left to right
            mov      ax, 2020h      ;2 blank in ax
            mov      cx, 15         ;clear 15 word
            lea      di, namedis
            rep      stosw
            ret
clrname     endp
;********************************
clrscr      proc     near           ;ax set on entry
            mov      bh, 30         ;color attribute
            mov      cx, 0
            mov      dx, 184fh      ;full screen
            int      10h
            ret
clrscr      endp
;********************************
locate      proc      near        ;dx set on entry
            mov       ah, 02h
            mov       bh, 00       ;page#
            int       10h
            ret
locate      endp
codesg      ends
            end      main 







































































































