Title    program direct video display
              .model     small
;********************************
videoseg      SEGMENT AT 0ba00h     ;page 2 of video area
videoarea     db         1000h  dup (?)
videoseg      ends
;********************************
              .data
msg           db         'press any key...'
;********************************
              .stack  64
;********************************
              .code
main          proc       far
              mov        ax, @data      ;addressing for 
              mov        ds, ax         ;data segment
              mov        ax, videoseg   ;and 
              mov        es, ax         ;video area
              assume     es:videoseg
              mov        ah, 0fh        ;get and save
              int        10h            ;current mode
              push       ax
              push       bx             ;and page
              mov        ah, 00h        ;request set mode
              mov        al, 03         ;03, clear screen
              int        10h

              mov        ah, 05h        ;request set
              mov        al, 02h        ;pge# 02
              int        10h

              call       outproc       ;process display area
              call       message        ;display user prompt
              call       inputkey      ;provide for input
              mov        ah, 05h       ;restore
              pop        bx            ;original page number
              mov        al, bh
              int        10h
              pop        ax            ;resore video mode
              mov        ah, 00h       ;in al
              int        10h
              mov        ax, 4c00h
              int        21h
main          endp
;************************************
outproc       proc       near
              mov        al, 41h       ;char to display
              mov        ah, 01h       ;attribute
              mov        di, 660       ;start of display area
p1:           mov        cx, 60        ;# of char per row
              rep        stosw         ;repeat 60 times
              inc        ah            ;next attribute
              inc        al            ;next char
              add        di, 40        ;next row
              cmp        al, 51h       ;last char to display?
              jne        p1            ;no, repeat
              ret                      ;yes, return
outproc       endp
;************************************
message     proc       near
              mov        ah, 03h       ;new attribute in ah
              mov        cx, 16        ;chars to display
              mov        di, 3840      ;locationin display area
              lea        si, msg
p2:           lodsb                    ;load char to al
              stosw                    ;store in display area
              loop       p2
              ret
message       endp
;************************************
inputkey      proc       near
              mov        ah, 10h       ;request keyboard input
              int        16h
              ret
inputkey      endp
              end        main 























































