program test;
  uses crt;
  type tree = ^rec;
       rec = record
            left  : tree;
            name  : string;
            seat  : integer;
            class : string;
            num   : integer;
            right : tree;
       end;
       tfile = file of rec;
  var root, p, q, s : tree;
      choice, find : byte;
      name : string;
      fp : tfile;
      rec1 : rec;
{************************}
  function menu : byte;
     var choice : byte;
  begin
      writeln('1 . Enter a passenger');
      writeln('2 . Report all passengers');
      writeln('3 . Search a passenger');
      writeln('4 . Save tree in a file');
      writeln('5 . Load tree from file');
      writeln('6 . Exit');
      writeln;
      write('Enter your select(1-6):');
      readln(choice);
      menu := choice;
  end;
{************************}
  procedure insrt(var root : tree ; p : tree);
  begin
     q := root;
     while q <> nil do
     begin
          if p^.name > q^.name then
          begin
             if q^.right = nil then
             begin
                q^.right := p;
                break;
             end
             else
                 q := q^.right;
          end
          else
          begin
             if q^.left = nil then
             begin
                q^.left := p;
                break
             end
             else
                q := q^.left;
          end;
      end;{while};
  end;{insrt}
{************************}
  procedure enter(var root : tree);
  begin
      clrscr;
      new(p);
      writeln('name:' , 'seat :' : 26);
      writeln( 'class:' , 'number:' : 25);
      gotoxy(10, 1);  readln(p^.name);
      gotoxy(35, 1);  readln(p^.seat);
      gotoxy(10, 2);  readln(p^.class);
      gotoxy(35, 2);  readln(p^.num);
      p^.right := nil;
      p^.left  := nil;
      if root = nil then
         root := p
      else
         insrt(root, p)
  end;
{************************}
  procedure head(title : string);
     var i : byte;
  begin
     clrscr;
     writeln(title :40);
     write('name' : 15 ,'  seat  ' : 20);
     writeln(' class ': 10, ' number ');
     write('     ');
     for i := 1 to 45 do
        write('-');
     writeln;
  end;
{************************}
  procedure report(var s : tree);
  begin
    if s <> nil then
     begin
       report(s^.left);
       writeln(s^.name:15 , s^.seat:16, s^.class : 12, s^.num:8);
       report(s^.right);
     end;
  end;
{************************}
  procedure search(s : tree; name : string; find : byte);
  begin
     if s <> nil then
     begin
       search(s^.left, name, find);
       if s^.name = name then
       begin
         head('<< searh a passenger >>');
         writeln(s^.name:15 , s^.seat:16, s^.class : 12, s^.num:8);
         readln;
         find := 1;
         exit;
       end;
       search(s^.right, name, find);
      end;
  end;
{************************}
  procedure save(s : tree);
  begin
     if  s <> nil then
     begin
        save(s^.left);
        rec1 := s^;
        write(fp, rec1);
        save(s^.right)
     end;
  end;
{************************}
  procedure load(var root : tree);
  begin
     while not eof(fp) do
     begin
        new(p);
        read(fp, rec1);
        p^ := rec1;
        p^.left := nil;
        p^.right := nil;
        if root = nil then
           root := p
        else
           insrt(root, p);
     end;
  end;
{************************}
begin{test}
  root := nil;
  repeat
    clrscr;
    find := 0;
    choice := menu;
    case choice of
        1 : enter(root);
        2 : begin
              if root = nil then
              begin
                writeln('tree is empty!');
                readln
              end
              else
              begin
                 head('<<report all passengers>>');
                 report(root);
                 readln
              end;
            end;
        3 : begin
              write('Enter name to search:');
              readln(name);
              search(root, name, find);
              if find = 0 then
              begin
                 writeln('name < ', name, '> not exist!');
                 readln
              end;
            end;
        4 : begin
              if root = nil then
              begin
                  write('tree is empty!');
                  readln;
              end
              else
              begin
                assign(fp, 'tree.dat');
                rewrite(fp);
                save(root);
                writeln('file tree succesfully saved.');
                close(fp);
                readln
              end;
            end;
        5 : begin
              if root <> nil then
              begin
                write('tree is already exit!');
                readln
              end
              else
              begin
                assign(fp, 'tree.dat');
                reset(fp);
                load(root);
                close(fp);
                writeln('file file succesfully loaded.');
                readln
              end;
            end;
    end;
  until choice = 6;
end.
